/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.KVMUtil;
import com.library.LoggerUtil;

public class KeyboardImpl {
    private static boolean initial;

    public static native int install();

    public static native int remove();

    public static native int getScanCode();

    public static void install_s() {
        try {
            KeyboardImpl.install();
            initial = true;
        }
        catch (Throwable e) {
            LoggerUtil.error("install keyboard library error.");
        }
    }

    public static void remove_s() {
        try {
            KeyboardImpl.remove();
            initial = false;
        }
        catch (Throwable e) {
            LoggerUtil.error("remove keyboard library error.");
        }
    }

    public static int getScanCode_s() {
        int code = 0;
        try {
            if (initial) {
                code = KeyboardImpl.getScanCode();
            }
        }
        catch (Throwable e) {
            LoggerUtil.error("get scancode error.");
        }
        return code;
    }

    static {
        String s1 = System.getProperty("file.separator");
        String s2 = System.getProperty("java.io.tmpdir");
        String keyboardLib = Base.getKEYBOARD_LIB();
        String keyboardLibExt = ".so";
        if (KVMUtil.isLinuxOS() && s2 != null) {
            if (s1 != null && !s2.endsWith(s1)) {
                s2 = s2 + s1;
            }
            s2 = s2 + keyboardLib + Base.getLibID() + keyboardLibExt;
            try {
                System.load(s2);
            }
            catch (Throwable e) {
                LoggerUtil.error("load keyboard library error.");
            }
        }
        initial = false;
    }
}

