/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.FileEntryPosition;
import com.kvm.FileType;
import com.kvm.UDFExtendFile;
import com.kvm.UDFImageBuilderFile;
import com.kvm.UdfLayoutInformation;
import com.library.LoggerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UDFImageBuilder {
    private String imageIdentifier = "Test-Disc";
    private String applicationIdentifier = "*SabreUDFImageBuilder";
    private byte[] applicationIdentifierSuffix = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private int blockSize = 2048;
    private byte[] udfVersionIdentifierSuffix = new byte[]{2, 1, 0, 0, 0, 0, 0, 0};
    private UDFImageBuilderFile rootUDFImageBuilderFile;
    private String version = "Revision102";
    private int maximumAllocationLength = 1073739776;
    private Map<Long, UDFExtendFile> extendMap = new HashMap<Long, UDFExtendFile>();
    private Map<Integer, Long> keyMap = new HashMap<Integer, Long>();
    ArrayList<Long> keylist = new ArrayList();
    private UdfLayoutInformation udfLayoutInformation;

    public void setRootPath(File rootPath) throws Exception {
        this.rootUDFImageBuilderFile = this.creatUdfImageBuilderFile(rootPath);
    }

    public UDFImageBuilderFile creatUdfImageBuilderFile(File dirFile) {
        UDFImageBuilderFile rootUdfImageBuilderFile = new UDFImageBuilderFile("");
        File[] childFiles = dirFile.listFiles();
        if (null != childFiles) {
            for (int i = 0; i < childFiles.length; ++i) {
                rootUdfImageBuilderFile.addChild(childFiles[i]);
            }
        }
        return rootUdfImageBuilderFile;
    }

    public void setImageIdentifier(String imageIdentifier) throws IndexOutOfBoundsException {
        if (imageIdentifier.length() > 30) {
            throw new IndexOutOfBoundsException("\u6355\u83b7\u5f02\u5e38,id.length>30");
        }
        this.imageIdentifier = imageIdentifier;
    }

    public UDFImageBuilderFile getRootUDFImageBuilderFile() {
        return this.rootUDFImageBuilderFile;
    }

    public void excute() throws IOException {
        UdfLayoutInformation myUdfLayoutInformation = new UdfLayoutInformation();
        myUdfLayoutInformation.init(this.rootUDFImageBuilderFile, this.version, this.blockSize);
        this.udfLayoutInformation = myUdfLayoutInformation;
        for (int i = 0; i < myUdfLayoutInformation.linearUDFImageBuilderFileOrdering.size(); ++i) {
            UDFImageBuilderFile udfImageFile = myUdfLayoutInformation.linearUDFImageBuilderFileOrdering.get(i);
            if (udfImageFile.getFileType() != FileType.File || udfImageFile.getFileLength() > 1872L) continue;
            udfImageFile.setSourceFileArray(this.writeToByteArray(udfImageFile));
        }
        this.writeImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeToByteArray(UDFImageBuilderFile udfImageFile) {
        FileInputStream fi = null;
        byte[] buf = new byte[(int)udfImageFile.getSourceFile().length()];
        try {
            fi = new FileInputStream(udfImageFile.getSourceFile());
            int c = fi.read(buf, 0, buf.length);
            if (c == -1) {
                byte[] byArray = buf;
                return byArray;
            }
        }
        catch (FileNotFoundException e) {
            LoggerUtil.error("FILE NOT FOUND");
        }
        catch (IOException e) {
            LoggerUtil.error("IOException");
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                LoggerUtil.error("IOException");
            }
        }
        return buf;
    }

    public Map<Long, UDFExtendFile> getExtendMap() {
        return this.extendMap;
    }

    private void writeImage() throws IOException {
        long recordingTimeMillis = new Date().getTime();
        if (this.udfLayoutInformation == null) {
            return;
        }
        UdfLayoutInformation myUDFLayoutInformation = this.udfLayoutInformation;
        this.keyMap.put(0, 0L);
        this.keylist.add(0L);
        this.writeReserve();
        this.writeVRS();
        this.writeEmptyArea();
        this.writeAVDP(myUDFLayoutInformation.AVDP1Block, myUDFLayoutInformation.MVDSStartingBlock, myUDFLayoutInformation.RVDSStartingBlock);
        this.writePVD(myUDFLayoutInformation.PVD1Block, recordingTimeMillis);
        this.writePD(myUDFLayoutInformation, myUDFLayoutInformation.PD1Block);
        this.writeLVD(myUDFLayoutInformation, myUDFLayoutInformation.LVD1Block);
        this.writeUSD(myUDFLayoutInformation.USD1Block);
        this.writeIUVD(myUDFLayoutInformation.IUVD1Block);
        this.writeTD(myUDFLayoutInformation.TD1Block);
        this.writeEmptyArea2();
        this.writeLVID(myUDFLayoutInformation, recordingTimeMillis);
        this.writeTD(myUDFLayoutInformation.LVIDSStartingBlock + 1L);
        this.writeEmptyArea3();
        this.writeEmptyArea4();
        this.writeFSD(myUDFLayoutInformation, recordingTimeMillis);
        for (int f = 0; f < myUDFLayoutInformation.linearUDFImageBuilderFileOrdering.size(); ++f) {
            int i;
            int i2;
            int i3;
            byte[] UniqueID;
            byte[] LogicalBlocksRecordedUint64;
            byte[] InformationLength;
            byte[] fe_body;
            long LogicalBlocksRecorded;
            int ICBTagFlags;
            long l_ad;
            UDFImageBuilderFile udfImageFile = myUDFLayoutInformation.linearUDFImageBuilderFileOrdering.get(f);
            FileEntryPosition myFileEntyPosition = udfImageFile.getFileEntryPosition();
            if (udfImageFile.getFileType() == FileType.File) {
                int j;
                int bufferLength = 2048;
                byte[] fe = new byte[bufferLength];
                long fileLength = udfImageFile.getFileLength();
                l_ad = 0L;
                if (fileLength <= 1872L) {
                    l_ad = fileLength;
                    ICBTagFlags = 3;
                    LogicalBlocksRecorded = 0L;
                } else {
                    ICBTagFlags = 1;
                    LogicalBlocksRecorded = (long)Math.ceil((double)fileLength / 2048.0);
                    for (long restFileSize = fileLength; restFileSize > 0L; restFileSize -= (long)this.maximumAllocationLength) {
                        l_ad += 16L;
                    }
                }
                fe_body = new byte[(int)(160L + l_ad)];
                fe_body[0] = 0;
                fe_body[1] = 0;
                fe_body[2] = 0;
                fe_body[3] = 0;
                fe_body[4] = 4;
                fe_body[5] = 0;
                fe_body[8] = 1;
                fe_body[9] = 0;
                fe_body[11] = 5;
                fe_body[18] = (byte)(ICBTagFlags >> 0 & 0xFF);
                fe_body[19] = (byte)(ICBTagFlags >> 8 & 0xFF);
                fe_body[24] = -1;
                fe_body[25] = -1;
                fe_body[26] = -1;
                fe_body[27] = -1;
                fe_body[20] = -1;
                fe_body[21] = -1;
                fe_body[22] = -1;
                fe_body[23] = -1;
                fe_body[28] = -124;
                fe_body[29] = 16;
                fe_body[30] = 0;
                fe_body[31] = 0;
                fe_body[32] = (byte)(udfImageFile.getFileLinkCount() >> 0 & 0xFF);
                fe_body[33] = (byte)(udfImageFile.getFileLinkCount() >> 8 & 0xFF);
                fe_body[34] = 0;
                fe_body[35] = 0;
                fe_body[36] = 0;
                fe_body[37] = 0;
                fe_body[38] = 0;
                fe_body[39] = 0;
                InformationLength = this.int64ToBytes(fileLength);
                for (int i4 = 0; i4 < 8; ++i4) {
                    fe_body[i4 + 40] = (byte)(InformationLength[i4] & 0xFF);
                }
                LogicalBlocksRecordedUint64 = this.int64ToBytes(LogicalBlocksRecorded);
                for (int i5 = 0; i5 < 8; ++i5) {
                    fe_body[i5 + 48] = LogicalBlocksRecordedUint64[i5];
                }
                byte[] AccessTime2 = this.millis2TimeStamp(udfImageFile.getAccessTime());
                for (int j2 = 0; j2 < 12; ++j2) {
                    fe_body[j2 + 56] = (byte)(AccessTime2[j2] & 0xFF);
                }
                byte[] ModificationTime2 = this.millis2TimeStamp(udfImageFile.getModificationTime());
                for (int j3 = 0; j3 < 12; ++j3) {
                    fe_body[j3 + 68] = (byte)(ModificationTime2[j3] & 0xFF);
                }
                byte[] AttributeTime2 = this.millis2TimeStamp(udfImageFile.getAttributeTime());
                for (int j4 = 0; j4 < 12; ++j4) {
                    fe_body[j4 + 80] = (byte)(AttributeTime2[j4] & 0xFF);
                }
                fe_body[92] = 1;
                fe_body[93] = 0;
                fe_body[94] = 0;
                fe_body[95] = 0;
                fe_body[112] = 0;
                byte[] ApplicationIdentifier2 = this.stringToBytes(this.applicationIdentifier);
                for (j = 0; j < ApplicationIdentifier2.length; ++j) {
                    fe_body[j + 113] = (byte)(ApplicationIdentifier2[j] & 0xFF);
                }
                for (j = 0; j < 8; ++j) {
                    fe_body[j + 136] = this.applicationIdentifierSuffix[j];
                }
                UniqueID = this.int64ToBytes(myFileEntyPosition.getUniqueIds());
                for (int j5 = 0; j5 < 8; ++j5) {
                    fe_body[j5 + 144] = (byte)(UniqueID[j5] & 0xFF);
                }
                fe_body[156] = (byte)(l_ad >> 0 & 0xFFL);
                fe_body[157] = (byte)(l_ad >> 8 & 0xFFL);
                fe_body[158] = (byte)(l_ad >> 16 & 0xFFL);
                fe_body[159] = (byte)(l_ad >> 24 & 0xFFL);
                if (fileLength <= 1872L) {
                    if (udfImageFile.getSourceFile() != null) {
                        byte[] byteArray = udfImageFile.getSourceFileArray();
                        for (int i6 = 0; i6 < byteArray.length; ++i6) {
                            fe_body[i6 + 160] = byteArray[i6];
                        }
                    }
                } else {
                    long currentExtentPosition = myFileEntyPosition.getDataLocation();
                    int j6 = 0;
                    for (long restFileSize = fileLength; restFileSize > 0L; restFileSize -= (long)this.maximumAllocationLength) {
                        long ExtentLength = restFileSize < (long)this.maximumAllocationLength ? restFileSize : (long)this.maximumAllocationLength;
                        fe_body[160 + j6 * 16 + 0] = (byte)(ExtentLength >> 0 & 0xFFL);
                        fe_body[160 + j6 * 16 + 1] = (byte)(ExtentLength >> 8 & 0xFFL);
                        fe_body[160 + j6 * 16 + 2] = (byte)(ExtentLength >> 16 & 0xFFL);
                        fe_body[160 + j6 * 16 + 3] = (byte)(ExtentLength >> 24 & 0xFFL);
                        fe_body[160 + j6 * 16 + 4] = (byte)(currentExtentPosition >> 0 & 0xFFL);
                        fe_body[160 + j6 * 16 + 5] = (byte)(currentExtentPosition >> 8 & 0xFFL);
                        fe_body[160 + j6 * 16 + 6] = (byte)(currentExtentPosition >> 16 & 0xFFL);
                        fe_body[160 + j6 * 16 + 7] = (byte)(currentExtentPosition >> 24 & 0xFFL);
                        ++j6;
                        currentExtentPosition = (long)((double)currentExtentPosition + Math.ceil((double)this.maximumAllocationLength / 2048.0));
                    }
                }
                int DescriptorCRC = this.checkSum(fe_body);
                fe[0] = 5;
                fe[1] = 1;
                fe[2] = 2;
                fe[3] = 0;
                fe[6] = 1;
                fe[7] = 0;
                fe[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
                fe[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
                fe[10] = (byte)(160L + l_ad >> 0 & 0xFFL);
                fe[11] = (byte)(160L + l_ad >> 8 & 0xFFL);
                fe[12] = (byte)(myFileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
                fe[13] = (byte)(myFileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
                fe[14] = (byte)(myFileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
                fe[15] = (byte)(myFileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
                int checksum = fe[0] + fe[1] + fe[2] + fe[3] + fe[5] + fe[6] + fe[7] + fe[8] + fe[9] + fe[10] + fe[11] + fe[12] + fe[13] + fe[14] + fe[15] & 0xFF;
                fe[4] = (byte)(checksum & 0xFF);
                for (int i7 = 0; i7 < fe_body.length; ++i7) {
                    fe[i7 + 16] = fe_body[i7];
                }
                this.writeToMap(fe);
                continue;
            }
            byte[] fe = new byte[2048];
            long fidLength = 40L;
            ArrayList<UDFImageBuilderFile> childUDFImageBuilderFiles = udfImageFile.getChilds();
            for (int i8 = 0; i8 < childUDFImageBuilderFiles.size(); ++i8) {
                long lengthWithoutPadding = 38 + this.stringToBytes1(childUDFImageBuilderFiles.get(i8).getIdentifier()).length;
                long paddingLength = lengthWithoutPadding % 4L == 0L ? 0L : 4L - lengthWithoutPadding % 4L;
                fidLength += lengthWithoutPadding + paddingLength;
            }
            l_ad = 0L;
            if (fidLength <= 1872L) {
                l_ad = fidLength;
                ICBTagFlags = 3;
                LogicalBlocksRecorded = 0L;
            } else {
                ICBTagFlags = 0;
                LogicalBlocksRecorded = (long)Math.ceil((double)fidLength / 2048.0);
                l_ad = 8L;
            }
            fe_body = new byte[(int)(160L + l_ad)];
            fe_body[0] = 0;
            fe_body[1] = 0;
            fe_body[2] = 0;
            fe_body[3] = 0;
            fe_body[4] = 4;
            fe_body[5] = 0;
            fe_body[8] = 1;
            fe_body[9] = 0;
            fe_body[11] = 4;
            fe_body[18] = (byte)(ICBTagFlags >> 0 & 0xFF);
            fe_body[19] = (byte)(ICBTagFlags >> 8 & 0xFF);
            fe_body[20] = -1;
            fe_body[21] = -1;
            fe_body[22] = -1;
            fe_body[23] = -1;
            fe_body[24] = -1;
            fe_body[25] = -1;
            fe_body[26] = -1;
            fe_body[27] = -1;
            fe_body[28] = -91;
            fe_body[29] = 20;
            fe_body[30] = 0;
            fe_body[31] = 0;
            fe_body[32] = (byte)(udfImageFile.getFileLinkCount() >> 0 & 0xFF);
            fe_body[33] = (byte)(udfImageFile.getFileLinkCount() >> 8 & 0xFF);
            fe_body[34] = 0;
            fe_body[35] = 0;
            fe_body[36] = 0;
            fe_body[37] = 0;
            fe_body[38] = 0;
            fe_body[39] = 0;
            InformationLength = this.int64ToBytes(fidLength);
            for (int i9 = 0; i9 < 8; ++i9) {
                fe_body[i9 + 40] = (byte)(InformationLength[i9] & 0xFF);
            }
            LogicalBlocksRecordedUint64 = this.int64ToBytes(LogicalBlocksRecorded);
            for (int i10 = 0; i10 < 8; ++i10) {
                fe_body[i10 + 48] = (byte)(LogicalBlocksRecordedUint64[i10] & 0xFF);
            }
            byte[] AccessTime = this.millis2TimeStamp(udfImageFile.getAccessTime());
            for (int i11 = 0; i11 < 12; ++i11) {
                fe_body[i11 + 56] = (byte)(AccessTime[i11] & 0xFF);
            }
            byte[] ModificationTime = this.millis2TimeStamp(udfImageFile.getModificationTime());
            for (int i12 = 0; i12 < 12; ++i12) {
                fe_body[i12 + 68] = (byte)(ModificationTime[i12] & 0xFF);
            }
            byte[] AttributeTime = this.millis2TimeStamp(udfImageFile.getAttributeTime());
            for (int i13 = 0; i13 < 12; ++i13) {
                fe_body[i13 + 80] = (byte)(AttributeTime[i13] & 0xFF);
            }
            fe_body[92] = 1;
            fe_body[93] = 0;
            fe_body[94] = 0;
            fe_body[95] = 0;
            fe_body[112] = 0;
            byte[] ApplicationIdentifier = this.stringToBytes(this.applicationIdentifier);
            for (i3 = 0; i3 < ApplicationIdentifier.length; ++i3) {
                fe_body[i3 + 113] = (byte)(ApplicationIdentifier[i3] & 0xFF);
            }
            for (i3 = 0; i3 < 8; ++i3) {
                fe_body[i3 + 136] = this.applicationIdentifierSuffix[i3];
            }
            UniqueID = this.int64ToBytes(myFileEntyPosition.getUniqueIds());
            for (int i14 = 0; i14 < 8; ++i14) {
                fe_body[i14 + 144] = (byte)(UniqueID[i14] & 0xFF);
            }
            fe_body[156] = (byte)(l_ad >> 0 & 0xFFL);
            fe_body[157] = (byte)(l_ad >> 8 & 0xFFL);
            fe_body[158] = (byte)(l_ad >> 16 & 0xFFL);
            fe_body[159] = (byte)(l_ad >> 24 & 0xFFL);
            byte[] fids = new byte[(int)fidLength];
            byte[] pFID = new byte[40];
            byte[] pFID_body = new byte[24];
            pFID_body[0] = 1;
            pFID_body[1] = 0;
            pFID_body[2] = 10;
            pFID_body[4] = 0;
            pFID_body[5] = 8;
            pFID_body[6] = 0;
            pFID_body[7] = 0;
            long parentDirectoryLocation = myFileEntyPosition.getEntryLocation();
            long parentDirectoryUniqueId = 0L;
            if (udfImageFile.getParent() != null) {
                parentDirectoryLocation = udfImageFile.getParent().getFileEntryPosition().getEntryLocation();
                parentDirectoryUniqueId = udfImageFile.getParent().getFileEntryPosition().getUniqueIds();
            }
            pFID_body[8] = (byte)(parentDirectoryLocation >> 0 & 0xFFL);
            pFID_body[9] = (byte)(parentDirectoryLocation >> 8 & 0xFFL);
            pFID_body[10] = (byte)(parentDirectoryLocation >> 16 & 0xFFL);
            pFID_body[11] = (byte)(parentDirectoryLocation >> 24 & 0xFFL);
            pFID_body[12] = 0;
            pFID_body[13] = 0;
            pFID_body[16] = (byte)(parentDirectoryUniqueId >> 0 & 0xFFL);
            pFID_body[17] = (byte)(parentDirectoryUniqueId >> 8 & 0xFFL);
            pFID_body[18] = (byte)(parentDirectoryUniqueId >> 16 & 0xFFL);
            pFID_body[19] = (byte)(parentDirectoryUniqueId >> 24 & 0xFFL);
            int DescriptorCRC = this.checkSum(pFID_body);
            pFID[0] = 1;
            pFID[1] = 1;
            pFID[2] = 2;
            pFID[3] = 0;
            pFID[5] = 0;
            pFID[6] = 1;
            pFID[7] = 0;
            pFID[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
            pFID[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
            pFID[10] = 24;
            pFID[11] = 0;
            pFID[12] = (byte)(myFileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
            pFID[13] = (byte)(myFileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
            pFID[14] = (byte)(myFileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
            pFID[15] = (byte)(myFileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
            int checksum = pFID[0] + pFID[1] + pFID[2] + pFID[3] + pFID[5] + pFID[6] + pFID[7] + pFID[8] + pFID[9] + pFID[10] + pFID[11] + pFID[12] + pFID[13] + pFID[14] + pFID[15] & 0xFF;
            pFID[4] = (byte)(checksum & 0xFF);
            for (i2 = 0; i2 < pFID_body.length; ++i2) {
                pFID[i2 + 16] = pFID_body[i2];
            }
            for (i2 = 0; i2 < 40; ++i2) {
                fids[i2] = pFID[i2];
            }
            int fidPoint = 40;
            int[] everyFidStartPoint = new int[udfImageFile.getChilds().size() + 1];
            everyFidStartPoint[0] = 0;
            if (udfImageFile.getChilds().size() > 0) {
                everyFidStartPoint[1] = 40;
            }
            for (i = 0; i < udfImageFile.getChilds().size(); ++i) {
                int j;
                UDFImageBuilderFile cudfImageFile = udfImageFile.getChilds().get(i);
                String cidentifier = cudfImageFile.getIdentifier();
                long lengthWithoutPadding = 38 + this.stringToBytes1(childUDFImageBuilderFiles.get(i).getIdentifier()).length;
                long paddingLength = lengthWithoutPadding % 4L == 0L ? 0L : 4L - lengthWithoutPadding % 4L;
                long cfidLength = lengthWithoutPadding + paddingLength;
                byte[] cFID = new byte[(int)cfidLength];
                byte[] cFID_body = new byte[(int)(cfidLength - 16L)];
                cFID_body[0] = 1;
                cFID_body[1] = 0;
                cFID_body[2] = cudfImageFile.getFileType() == FileType.Directory ? 2 : 0;
                cFID_body[3] = (byte)(this.stringToBytes1(cidentifier).length >> 0 & 0xFF);
                cFID_body[4] = 0;
                cFID_body[5] = 8;
                cFID_body[6] = 0;
                cFID_body[7] = 0;
                FileEntryPosition cfileEntyPosition = cudfImageFile.getFileEntryPosition();
                cFID_body[8] = (byte)(cfileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
                cFID_body[9] = (byte)(cfileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
                cFID_body[10] = (byte)(cfileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
                cFID_body[11] = (byte)(cfileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
                cFID_body[12] = 0;
                cFID_body[13] = 0;
                cFID_body[16] = (byte)(cfileEntyPosition.getUniqueIds() >> 0 & 0xFFL);
                cFID_body[17] = (byte)(cfileEntyPosition.getUniqueIds() >> 8 & 0xFFL);
                cFID_body[18] = (byte)(cfileEntyPosition.getUniqueIds() >> 16 & 0xFFL);
                cFID_body[19] = (byte)(cfileEntyPosition.getUniqueIds() >> 24 & 0xFFL);
                byte[] cFileIdentifier = this.stringToBytes1(cidentifier);
                for (int j7 = 0; j7 < cFileIdentifier.length; ++j7) {
                    cFID_body[22 + j7] = cFileIdentifier[j7];
                }
                int DescriptorCRC2 = this.checkSum(cFID_body);
                cFID[0] = 1;
                cFID[1] = 1;
                cFID[2] = 2;
                cFID[3] = 0;
                cFID[5] = 0;
                cFID[6] = 1;
                cFID[7] = 0;
                cFID[8] = (byte)(DescriptorCRC2 >> 0 & 0xFF);
                cFID[9] = (byte)(DescriptorCRC2 >> 8 & 0xFF);
                cFID[10] = (byte)(cfidLength - 16L >> 0 & 0xFFL);
                cFID[11] = (byte)(cfidLength - 16L >> 8 & 0xFFL);
                cFID[12] = (byte)(myFileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
                cFID[13] = (byte)(myFileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
                cFID[14] = (byte)(myFileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
                cFID[15] = (byte)(myFileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
                int checksum2 = cFID[0] + cFID[1] + cFID[2] + cFID[3] + cFID[5] + cFID[6] + cFID[7] + cFID[8] + cFID[9] + cFID[10] + cFID[11] + cFID[12] + cFID[13] + cFID[14] + cFID[15] & 0xFF;
                cFID[4] = (byte)(checksum2 & 0xFF);
                for (j = 0; j < cFID_body.length; ++j) {
                    cFID[j + 16] = cFID_body[j];
                }
                j = 0;
                while ((long)j < cfidLength) {
                    fids[fidPoint++] = cFID[j];
                    ++j;
                }
                if (i >= udfImageFile.getChilds().size() - 1) continue;
                everyFidStartPoint[i + 2] = fidPoint;
            }
            if (fidLength <= 1872L) {
                for (i = 0; i < fids.length; ++i) {
                    fe_body[i + 160] = fids[i];
                }
                int DescriptorCRC3 = this.checkSum(fe_body);
                fe[0] = 5;
                fe[1] = 1;
                fe[2] = 2;
                fe[3] = 0;
                fe[5] = 0;
                fe[6] = 1;
                fe[7] = 0;
                fe[8] = (byte)(DescriptorCRC3 >> 0 & 0xFF);
                fe[9] = (byte)(DescriptorCRC3 >> 8 & 0xFF);
                fe[10] = (byte)(160L + l_ad >> 0 & 0xFFL);
                fe[11] = (byte)(160L + l_ad >> 8 & 0xFFL);
                fe[12] = (byte)(myFileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
                fe[13] = (byte)(myFileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
                fe[14] = (byte)(myFileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
                fe[15] = (byte)(myFileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
                int checksum3 = fe[0] + fe[1] + fe[2] + fe[3] + fe[5] + fe[6] + fe[7] + fe[8] + fe[9] + fe[10] + fe[11] + fe[12] + fe[13] + fe[14] + fe[15] & 0xFF;
                fe[4] = (byte)(checksum3 & 0xFF);
                for (int i15 = 0; i15 < fe_body.length; ++i15) {
                    fe[i15 + 16] = fe_body[i15];
                }
                this.writeToMap(fe);
                continue;
            }
            fe_body[160] = (byte)(fidLength >> 0 & 0xFFL);
            fe_body[161] = (byte)(fidLength >> 8 & 0xFFL);
            fe_body[162] = (byte)(fidLength >> 16 & 0xFFL);
            fe_body[163] = (byte)(fidLength >> 24 & 0xFFL);
            fe_body[164] = (byte)(myFileEntyPosition.getDataLocation() >> 0 & 0xFFL);
            fe_body[165] = (byte)(myFileEntyPosition.getDataLocation() >> 8 & 0xFFL);
            fe_body[166] = (byte)(myFileEntyPosition.getDataLocation() >> 16 & 0xFFL);
            fe_body[167] = (byte)(myFileEntyPosition.getDataLocation() >> 24 & 0xFFL);
            int DescriptorCRC4 = this.checkSum(fe_body);
            fe[0] = 5;
            fe[1] = 1;
            fe[2] = 2;
            fe[3] = 0;
            fe[5] = 0;
            fe[6] = 1;
            fe[7] = 0;
            fe[8] = (byte)(DescriptorCRC4 >> 0 & 0xFF);
            fe[9] = (byte)(DescriptorCRC4 >> 8 & 0xFF);
            fe[10] = (byte)(160L + l_ad >> 0 & 0xFFL);
            fe[11] = (byte)(160L + l_ad >> 8 & 0xFFL);
            fe[12] = (byte)(myFileEntyPosition.getEntryLocation() >> 0 & 0xFFL);
            fe[13] = (byte)(myFileEntyPosition.getEntryLocation() >> 8 & 0xFFL);
            fe[14] = (byte)(myFileEntyPosition.getEntryLocation() >> 16 & 0xFFL);
            fe[15] = (byte)(myFileEntyPosition.getEntryLocation() >> 24 & 0xFFL);
            int checksum5 = fe[0] + fe[1] + fe[2] + fe[3] + fe[5] + fe[6] + fe[7] + fe[8] + fe[9] + fe[10] + fe[11] + fe[12] + fe[13] + fe[14] + fe[15] & 0xFF;
            fe[4] = (byte)(checksum5 & 0xFF);
            for (int i16 = 0; i16 < fe_body.length; ++i16) {
                fe[i16 + 16] = fe_body[i16];
            }
            long currentRealPosition = 2048L * myFileEntyPosition.getDataLocation();
            for (int i17 = 0; i17 < everyFidStartPoint.length; ++i17) {
                long tagLocationBlock = (long)Math.floor((double)currentRealPosition / 2048.0);
                int n = everyFidStartPoint[i17] + 4;
                fids[n] = (byte)(fids[n] - fids[everyFidStartPoint[i17] + 12]);
                int n2 = everyFidStartPoint[i17] + 4;
                fids[n2] = (byte)(fids[n2] - fids[everyFidStartPoint[i17] + 13]);
                int n3 = everyFidStartPoint[i17] + 4;
                fids[n3] = (byte)(fids[n3] - fids[everyFidStartPoint[i17] + 14]);
                int n4 = everyFidStartPoint[i17] + 4;
                fids[n4] = (byte)(fids[n4] - fids[everyFidStartPoint[i17] + 15]);
                fids[everyFidStartPoint[i17] + 12] = (byte)(tagLocationBlock >> 0 & 0xFFL);
                fids[everyFidStartPoint[i17] + 13] = (byte)(tagLocationBlock >> 8 & 0xFFL);
                fids[everyFidStartPoint[i17] + 14] = (byte)(tagLocationBlock >> 16 & 0xFFL);
                fids[everyFidStartPoint[i17] + 15] = (byte)(tagLocationBlock >> 24 & 0xFFL);
                int n5 = everyFidStartPoint[i17] + 4;
                fids[n5] = (byte)(fids[n5] + fids[everyFidStartPoint[i17] + 12]);
                int n6 = everyFidStartPoint[i17] + 4;
                fids[n6] = (byte)(fids[n6] + fids[everyFidStartPoint[i17] + 13]);
                int n7 = everyFidStartPoint[i17] + 4;
                fids[n7] = (byte)(fids[n7] + fids[everyFidStartPoint[i17] + 14]);
                int n8 = everyFidStartPoint[i17] + 4;
                fids[n8] = (byte)(fids[n8] + fids[everyFidStartPoint[i17] + 15]);
                if (i17 >= everyFidStartPoint.length - 1) continue;
                currentRealPosition += (long)(everyFidStartPoint[i17 + 1] - everyFidStartPoint[i17]);
            }
            long paddingLength = fidLength % 2048L == 0L ? 0L : 2048L - fidLength % 2048L;
            byte[] paddingArray = new byte[(int)paddingLength];
            byte[] fesum = new byte[fe.length + fids.length + paddingArray.length];
            for (int i18 = 0; i18 < fe.length; ++i18) {
                fesum[i18] = fe[i18];
            }
            for (int i22 = 0; i22 < fids.length; ++i22) {
                fesum[i22 + fe.length] = fids[i22];
            }
            for (int i32 = 0; i32 < paddingArray.length; ++i32) {
                fesum[i32 + fe.length + fids.length] = paddingArray[i32];
            }
            this.writeToMap(fesum);
        }
        for (UDFImageBuilderFile myUDFImageBuilderFile : myUDFLayoutInformation.linearUDFImageBuilderFileOrdering) {
            FileEntryPosition myFileEntryPosition = myUDFImageBuilderFile.getFileEntryPosition();
            if (myUDFImageBuilderFile.getFileType() != FileType.File || myFileEntryPosition.getDataBlock() == -1L) continue;
            this.writeToMapLarge(myUDFImageBuilderFile.getSourceFile());
        }
        this.writePVD(myUDFLayoutInformation.PVD2Block, recordingTimeMillis);
        this.writePD(myUDFLayoutInformation, myUDFLayoutInformation.PD2Block);
        this.writeLVD(myUDFLayoutInformation, myUDFLayoutInformation.LVD2Block);
        this.writeUSD(myUDFLayoutInformation.USD2Block);
        this.writeIUVD(myUDFLayoutInformation.IUVD2Block);
        this.writeTD(myUDFLayoutInformation.TD2Block);
        this.writeEmptyBlock((int)(myUDFLayoutInformation.RVDSEndingBlock - myUDFLayoutInformation.RVDSStartingBlock - 5L));
        this.writeAVDP(myUDFLayoutInformation.AVDP2Block, myUDFLayoutInformation.MVDSStartingBlock, myUDFLayoutInformation.RVDSStartingBlock);
    }

    private void writeFSD(UdfLayoutInformation myUDFLayoutInformation, long recordingTimeMillis) {
        int i;
        int i2;
        byte[] fsd = new byte[2048];
        byte[] fsd_body = new byte[496];
        byte[] mytimestamp = this.millis2TimeStamp(recordingTimeMillis);
        for (int i3 = 0; i3 < 12; ++i3) {
            fsd_body[i3] = mytimestamp[i3];
        }
        fsd_body[12] = 3;
        fsd_body[13] = 0;
        fsd_body[14] = 3;
        fsd_body[15] = 0;
        fsd_body[16] = 1;
        fsd_body[17] = 0;
        fsd_body[18] = 0;
        fsd_body[19] = 0;
        fsd_body[20] = 1;
        fsd_body[21] = 0;
        fsd_body[22] = 0;
        fsd_body[23] = 0;
        fsd_body[24] = 0;
        fsd_body[25] = 0;
        fsd_body[26] = 0;
        fsd_body[27] = 0;
        fsd_body[28] = 0;
        fsd_body[29] = 0;
        fsd_body[30] = 0;
        fsd_body[31] = 0;
        fsd_body[32] = 0;
        byte[] DescriptorCharacterSet = this.stringToBytes("OSTA Compressed Unicode");
        for (int i4 = 0; i4 < DescriptorCharacterSet.length; ++i4) {
            fsd_body[i4 + 33] = (byte)(DescriptorCharacterSet[i4] & 0xFF);
        }
        byte[] LogicalVolumeIdentifier = this.stringToBytes1(this.imageIdentifier);
        for (i2 = 0; i2 < LogicalVolumeIdentifier.length; ++i2) {
            fsd_body[i2 + 96] = LogicalVolumeIdentifier[i2];
        }
        fsd_body[223] = (byte)(LogicalVolumeIdentifier.length & 0xFF);
        fsd_body[224] = 0;
        for (i2 = 0; i2 < DescriptorCharacterSet.length; ++i2) {
            fsd_body[i2 + 225] = (byte)(DescriptorCharacterSet[i2] & 0xFF);
        }
        byte[] FileSetIdentifier = this.stringToBytes1(this.imageIdentifier);
        for (int i5 = 0; i5 < FileSetIdentifier.length; ++i5) {
            fsd_body[i5 + 288] = FileSetIdentifier[i5];
        }
        fsd_body[319] = (byte)(FileSetIdentifier.length & 0xFF);
        fsd_body[384] = 0;
        fsd_body[385] = 8;
        fsd_body[386] = 0;
        fsd_body[387] = 0;
        fsd_body[388] = (byte)(myUDFLayoutInformation.rootFELocation >> 0 & 0xFFL);
        fsd_body[389] = (byte)(myUDFLayoutInformation.rootFELocation >> 8 & 0xFFL);
        fsd_body[390] = (byte)(myUDFLayoutInformation.rootFELocation >> 16 & 0xFFL);
        fsd_body[391] = (byte)(myUDFLayoutInformation.rootFELocation >> 24 & 0xFFL);
        fsd_body[392] = (byte)(myUDFLayoutInformation.partitionToStoreMetadataOn >> 0 & 0xFF);
        fsd_body[393] = (byte)(myUDFLayoutInformation.partitionToStoreMetadataOn >> 8 & 0xFF);
        fsd_body[400] = 0;
        byte[] DomainIdentifier = this.stringToBytes("*OSTA UDF Compliant");
        for (i = 0; i < DomainIdentifier.length; ++i) {
            fsd_body[401 + i] = DomainIdentifier[i];
        }
        for (i = 0; i < 8; ++i) {
            fsd_body[424 + i] = this.udfVersionIdentifierSuffix[i];
        }
        int DescriptorCRC = this.checkSum(fsd_body);
        fsd[0] = 0;
        fsd[1] = 1;
        fsd[2] = 2;
        fsd[3] = 0;
        fsd[5] = 0;
        fsd[6] = 1;
        fsd[7] = 0;
        fsd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        fsd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        fsd[10] = -16;
        fsd[11] = 1;
        fsd[12] = (byte)(myUDFLayoutInformation.FSDLocation >> 0 & 0xFFL);
        fsd[13] = (byte)(myUDFLayoutInformation.FSDLocation >> 8 & 0xFFL);
        fsd[14] = (byte)(myUDFLayoutInformation.FSDLocation >> 16 & 0xFFL);
        fsd[15] = (byte)(myUDFLayoutInformation.FSDLocation >> 24 & 0xFFL);
        int checksum = fsd[0] + fsd[1] + fsd[2] + fsd[3] + fsd[5] + fsd[6] + fsd[7] + fsd[8] + fsd[9] + fsd[10] + fsd[11] + fsd[12] + fsd[13] + fsd[14] + fsd[15] & 0xFF;
        fsd[4] = (byte)(checksum & 0xFF);
        for (int i6 = 0; i6 < fsd_body.length; ++i6) {
            fsd[i6 + 16] = fsd_body[i6];
        }
        this.writeToMap(fsd);
    }

    private void writeLVID(UdfLayoutInformation myUDFLayoutInformation, long recordingTimeMillis) {
        int i;
        byte[] lvid = new byte[2048];
        byte[] lvid_body = new byte[118];
        byte[] mytimestamp = this.millis2TimeStamp(recordingTimeMillis);
        for (int i2 = 0; i2 < 12; ++i2) {
            lvid_body[i2] = mytimestamp[i2];
        }
        lvid_body[12] = 1;
        lvid_body[13] = 0;
        lvid_body[14] = 0;
        lvid_body[15] = 0;
        byte[] nextUniqueId = this.int64ToBytes(myUDFLayoutInformation.nextUniqueId);
        for (int i3 = 0; i3 < 8; ++i3) {
            lvid_body[i3 + 24] = nextUniqueId[i3];
        }
        lvid_body[56] = 1;
        lvid_body[57] = 0;
        lvid_body[58] = 0;
        lvid_body[59] = 0;
        lvid_body[60] = 46;
        lvid_body[61] = 0;
        lvid_body[62] = 0;
        lvid_body[63] = 0;
        long SizeTable = myUDFLayoutInformation.physicalPartitionEndingBlock - myUDFLayoutInformation.physicalPartitionStartingBlock;
        lvid_body[68] = (byte)(SizeTable >> 0 & 0xFFL);
        lvid_body[69] = (byte)(SizeTable >> 8 & 0xFFL);
        lvid_body[70] = (byte)(SizeTable >> 16 & 0xFFL);
        lvid_body[71] = (byte)(SizeTable >> 24 & 0xFFL);
        lvid_body[72] = 0;
        byte[] ApplicationIdentifier = this.stringToBytes(this.applicationIdentifier);
        for (i = 0; i < ApplicationIdentifier.length; ++i) {
            lvid_body[i + 73] = (byte)(ApplicationIdentifier[i] & 0xFF);
        }
        for (i = 0; i < 8; ++i) {
            lvid_body[i + 96] = this.applicationIdentifierSuffix[i];
        }
        lvid_body[104] = (byte)(myUDFLayoutInformation.fileCount >> 0 & 0xFFL);
        lvid_body[105] = (byte)(myUDFLayoutInformation.fileCount >> 8 & 0xFFL);
        lvid_body[106] = (byte)(myUDFLayoutInformation.fileCount >> 16 & 0xFFL);
        lvid_body[107] = (byte)(myUDFLayoutInformation.fileCount >> 24 & 0xFFL);
        lvid_body[108] = (byte)(myUDFLayoutInformation.directoryCount >> 0 & 0xFFL);
        lvid_body[109] = (byte)(myUDFLayoutInformation.directoryCount >> 8 & 0xFFL);
        lvid_body[110] = (byte)(myUDFLayoutInformation.directoryCount >> 16 & 0xFFL);
        lvid_body[111] = (byte)(myUDFLayoutInformation.directoryCount >> 24 & 0xFFL);
        lvid_body[112] = 2;
        lvid_body[113] = 1;
        lvid_body[114] = 2;
        lvid_body[115] = 1;
        lvid_body[116] = 2;
        lvid_body[117] = 1;
        int DescriptorCRC = this.checkSum(lvid_body);
        lvid[0] = 9;
        lvid[1] = 0;
        lvid[2] = 2;
        lvid[3] = 0;
        lvid[5] = 0;
        lvid[6] = 1;
        lvid[7] = 0;
        lvid[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        lvid[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        lvid[10] = 118;
        lvid[11] = 0;
        lvid[12] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 0 & 0xFFL);
        lvid[13] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 8 & 0xFFL);
        lvid[14] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 16 & 0xFFL);
        lvid[15] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 24 & 0xFFL);
        int checksum = lvid[0] + lvid[1] + lvid[2] + lvid[3] + lvid[5] + lvid[6] + lvid[7] + lvid[8] + lvid[9] + lvid[10] + lvid[11] + lvid[12] + lvid[13] + lvid[14] + lvid[15] & 0xFF;
        lvid[4] = (byte)(checksum & 0xFF);
        for (int i4 = 0; i4 < lvid_body.length; ++i4) {
            lvid[i4 + 16] = lvid_body[i4];
        }
        this.writeToMap(lvid);
    }

    private void writePVD(long PVDBlock, long recordingTimeMillis) {
        int i;
        byte[] pvd = new byte[2048];
        byte[] pvd_body = new byte[496];
        pvd_body[0] = 1;
        pvd_body[1] = 0;
        pvd_body[2] = 0;
        pvd_body[3] = 0;
        pvd_body[4] = 0;
        pvd_body[5] = 0;
        pvd_body[6] = 0;
        pvd_body[7] = 0;
        byte[] VolumeIdentifier = this.stringToBytes1(this.imageIdentifier);
        for (int i2 = 0; i2 < VolumeIdentifier.length; ++i2) {
            pvd_body[i2 + 8] = (byte)(VolumeIdentifier[i2] & 0xFF);
        }
        pvd_body[39] = (byte)(VolumeIdentifier.length & 0xFF);
        pvd_body[40] = 1;
        pvd_body[41] = 0;
        pvd_body[42] = 1;
        pvd_body[43] = 0;
        pvd_body[44] = 2;
        pvd_body[45] = 0;
        pvd_body[46] = 3;
        pvd_body[47] = 0;
        pvd_body[48] = 1;
        pvd_body[49] = 0;
        pvd_body[50] = 0;
        pvd_body[51] = 0;
        pvd_body[52] = 1;
        pvd_body[53] = 0;
        pvd_body[54] = 0;
        pvd_body[55] = 0;
        byte[] VolumeSetIdentifier = this.stringToBytes1(Long.toHexString(recordingTimeMillis) + " " + this.imageIdentifier);
        for (int i3 = 0; i3 < VolumeSetIdentifier.length; ++i3) {
            pvd_body[i3 + 56] = (byte)(VolumeSetIdentifier[i3] & 0xFF);
        }
        pvd_body[183] = (byte)(VolumeSetIdentifier.length & 0xFF);
        pvd_body[184] = 0;
        byte[] DescriptorCharacterSet = this.stringToBytes("OSTA Compressed Unicode");
        for (int i4 = 0; i4 < DescriptorCharacterSet.length; ++i4) {
            pvd_body[i4 + 185] = (byte)(DescriptorCharacterSet[i4] & 0xFF);
        }
        pvd_body[248] = 0;
        byte[] SpecExplanatoryCharacterSet = this.stringToBytes("OSTA Compressed Unicode");
        for (int i5 = 0; i5 < SpecExplanatoryCharacterSet.length; ++i5) {
            pvd_body[i5 + 249] = (byte)(SpecExplanatoryCharacterSet[i5] & 0xFF);
        }
        pvd_body[328] = 0;
        byte[] ApplicationIdentifier = this.stringToBytes(this.applicationIdentifier);
        for (i = 0; i < ApplicationIdentifier.length; ++i) {
            pvd_body[i + 329] = (byte)(ApplicationIdentifier[i] & 0xFF);
        }
        for (i = 0; i < 8; ++i) {
            pvd_body[i + 329 + 23] = this.applicationIdentifierSuffix[i];
        }
        byte[] mytimestamp = this.millis2TimeStamp(recordingTimeMillis);
        for (int i6 = 0; i6 < 12; ++i6) {
            pvd_body[i6 + 360] = mytimestamp[i6];
        }
        pvd_body[372] = 0;
        byte[] ImplementationIdentifier = this.stringToBytes(this.applicationIdentifier);
        for (int i7 = 0; i7 < ImplementationIdentifier.length; ++i7) {
            pvd_body[i7 + 373] = (byte)(ImplementationIdentifier[i7] & 0xFF);
        }
        pvd_body[468] = 0;
        pvd_body[469] = 0;
        pvd_body[470] = 0;
        pvd_body[471] = 0;
        pvd_body[472] = 1;
        pvd_body[473] = 0;
        int DescriptorCRC = this.checkSum(pvd_body);
        pvd[0] = 1;
        pvd[1] = 0;
        pvd[2] = 2;
        pvd[3] = 0;
        pvd[5] = 0;
        pvd[6] = 1;
        pvd[7] = 0;
        pvd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        pvd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        pvd[10] = -16;
        pvd[11] = 1;
        pvd[12] = (byte)(PVDBlock >> 0 & 0xFFL);
        pvd[13] = (byte)(PVDBlock >> 8 & 0xFFL);
        pvd[14] = (byte)(PVDBlock >> 16 & 0xFFL);
        pvd[15] = (byte)(PVDBlock >> 24 & 0xFFL);
        int checksum = pvd[0] + pvd[1] + pvd[2] + pvd[3] + pvd[5] + pvd[6] + pvd[7] + pvd[8] + pvd[9] + pvd[10] + pvd[11] + pvd[12] + pvd[13] + pvd[14] + pvd[15] & 0xFF;
        pvd[4] = (byte)(checksum & 0xFF);
        for (int i8 = 0; i8 < pvd_body.length; ++i8) {
            pvd[i8 + 16] = pvd_body[i8];
        }
        this.writeToMap(pvd);
    }

    private byte[] millis2TimeStamp(long mills) {
        Date mydate = new Date(mills);
        Calendar cal = Calendar.getInstance();
        cal.setTime(mydate);
        byte[] mytimestamp = new byte[12];
        int twelveBitSignedValue = -(cal.get(15) + cal.get(16)) / 60000;
        if (twelveBitSignedValue < 0) {
            twelveBitSignedValue *= -1;
        }
        int TypeAndTimezone = 0x1000 | twelveBitSignedValue;
        mytimestamp[0] = (byte)(TypeAndTimezone >> 0 & 0xFF);
        mytimestamp[1] = (byte)(TypeAndTimezone >> 8 & 0xFF);
        mytimestamp[2] = (byte)(cal.get(1) - 1900 >> 0 & 0xFF);
        mytimestamp[3] = (byte)(cal.get(1) - 1900 >> 8 & 0xFF);
        mytimestamp[4] = (byte)(cal.get(2) + 1 & 0xFF);
        mytimestamp[5] = (byte)(cal.get(5) & 0xFF);
        mytimestamp[6] = (byte)(cal.get(11) & 0xFF);
        mytimestamp[7] = (byte)(cal.get(12) & 0xFF);
        mytimestamp[8] = (byte)(cal.get(13) & 0xFF);
        mytimestamp[9] = 0;
        mytimestamp[10] = 14;
        mytimestamp[11] = 0;
        return mytimestamp;
    }

    private void writeTD(long TDBlock) {
        byte[] td = new byte[2048];
        byte[] td_body = new byte[496];
        int DescriptorCRC = this.checkSum(td_body);
        td[0] = 8;
        td[1] = 0;
        td[2] = 2;
        td[3] = 0;
        td[5] = 0;
        td[6] = 1;
        td[7] = 0;
        td[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        td[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        td[10] = -16;
        td[11] = 1;
        td[12] = (byte)(TDBlock >> 0 & 0xFFL);
        td[13] = (byte)(TDBlock >> 8 & 0xFFL);
        td[14] = (byte)(TDBlock >> 16 & 0xFFL);
        td[15] = (byte)(TDBlock >> 24 & 0xFFL);
        int checksum = td[0] + td[1] + td[2] + td[3] + td[5] + td[6] + td[7] + td[8] + td[9] + td[10] + td[11] + td[12] + td[13] + td[14] + td[15] & 0xFF;
        td[4] = (byte)(checksum & 0xFF);
        for (int i = 0; i < td_body.length; ++i) {
            td[i + 16] = td_body[i];
        }
        this.writeToMap(td);
    }

    private void writeIUVD(long IUVDBlock) {
        int i;
        int i2;
        byte[] iuvd = new byte[2048];
        byte[] iuvd_body = new byte[496];
        iuvd_body[0] = 5;
        iuvd_body[1] = 0;
        iuvd_body[2] = 0;
        iuvd_body[3] = 0;
        iuvd_body[4] = 0;
        byte[] ImplementationIdentifier = this.stringToBytes("*UDF LV Info");
        for (i2 = 0; i2 < ImplementationIdentifier.length; ++i2) {
            iuvd_body[i2 + 5] = (byte)(ImplementationIdentifier[i2] & 0xFF);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            iuvd_body[i2 + 28] = this.udfVersionIdentifierSuffix[i2];
        }
        iuvd_body[36] = 0;
        byte[] DescriptorCharacterSet = this.stringToBytes("OSTA Compressed Unicode");
        for (int i3 = 0; i3 < DescriptorCharacterSet.length; ++i3) {
            iuvd_body[i3 + 37] = (byte)(DescriptorCharacterSet[i3] & 0xFF);
        }
        byte[] LogicalVolumeIdentifier = this.stringToBytes1(this.imageIdentifier);
        for (int i4 = 0; i4 < LogicalVolumeIdentifier.length; ++i4) {
            iuvd_body[i4 + 100] = LogicalVolumeIdentifier[i4];
        }
        iuvd_body[227] = (byte)(LogicalVolumeIdentifier.length & 0xFF);
        iuvd_body[336] = 0;
        byte[] ImplementationIdentifier2 = this.stringToBytes(this.applicationIdentifier);
        byte[] ImplementationIdentifierSuffix = this.applicationIdentifierSuffix;
        for (i = 0; i < ImplementationIdentifier.length; ++i) {
            iuvd_body[337 + i] = (byte)(ImplementationIdentifier2[i] & 0xFF);
        }
        for (i = 0; i < ImplementationIdentifierSuffix.length; ++i) {
            iuvd_body[360 + i] = (byte)(ImplementationIdentifierSuffix[i] & 0xFF);
        }
        int DescriptorCRC = this.checkSum(iuvd_body);
        iuvd[0] = 4;
        iuvd[1] = 0;
        iuvd[2] = 2;
        iuvd[3] = 0;
        iuvd[5] = 0;
        iuvd[6] = 1;
        iuvd[7] = 0;
        iuvd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        iuvd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        iuvd[10] = -16;
        iuvd[11] = 1;
        iuvd[12] = (byte)(IUVDBlock >> 0 & 0xFFL);
        iuvd[13] = (byte)(IUVDBlock >> 8 & 0xFFL);
        iuvd[14] = (byte)(IUVDBlock >> 16 & 0xFFL);
        iuvd[15] = (byte)(IUVDBlock >> 24 & 0xFFL);
        int checksum = iuvd[0] + iuvd[1] + iuvd[2] + iuvd[3] + iuvd[5] + iuvd[6] + iuvd[7] + iuvd[8] + iuvd[9] + iuvd[10] + iuvd[11] + iuvd[12] + iuvd[13] + iuvd[14] + iuvd[15] & 0xFF;
        iuvd[4] = (byte)(checksum & 0xFF);
        for (int i5 = 0; i5 < iuvd_body.length; ++i5) {
            iuvd[i5 + 16] = iuvd_body[i5];
        }
        this.writeToMap(iuvd);
    }

    private void writeUSD(long USDBlock) {
        byte[] usd = new byte[2048];
        byte[] usd_body = new byte[16];
        usd_body[0] = 4;
        usd_body[1] = 0;
        usd_body[2] = 0;
        usd_body[3] = 0;
        usd_body[4] = 1;
        usd_body[5] = 0;
        usd_body[6] = 0;
        usd_body[7] = 0;
        long usd_length = 485376L;
        usd_body[8] = (byte)(usd_length >> 0 & 0xFFL);
        usd_body[9] = (byte)(usd_length >> 8 & 0xFFL);
        usd_body[10] = (byte)(usd_length >> 16 & 0xFFL);
        usd_body[11] = (byte)(usd_length >> 24 & 0xFFL);
        usd_body[12] = 19;
        usd_body[13] = 0;
        usd_body[14] = 0;
        usd_body[15] = 0;
        int DescriptorCRC = this.checkSum(usd_body);
        usd[0] = 7;
        usd[1] = 0;
        usd[2] = 2;
        usd[3] = 0;
        usd[5] = 0;
        usd[6] = 1;
        usd[7] = 0;
        usd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        usd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        usd[10] = 16;
        usd[11] = 0;
        usd[12] = (byte)(USDBlock >> 0 & 0xFFL);
        usd[13] = (byte)(USDBlock >> 8 & 0xFFL);
        usd[14] = (byte)(USDBlock >> 16 & 0xFFL);
        usd[15] = (byte)(USDBlock >> 24 & 0xFFL);
        int checksum = usd[0] + usd[1] + usd[2] + usd[3] + usd[5] + usd[6] + usd[7] + usd[8] + usd[9] + usd[10] + usd[11] + usd[12] + usd[13] + usd[14] + usd[15] & 0xFF;
        usd[4] = (byte)(checksum & 0xFF);
        for (int i = 0; i < usd_body.length; ++i) {
            usd[i + 16] = usd_body[i];
        }
        this.writeToMap(usd);
    }

    private void writeLVD(UdfLayoutInformation myUDFLayoutInformation, long LVDBlock) {
        int i;
        int i2;
        byte[] lvd = new byte[2048];
        byte[] lvd_body = new byte[430];
        lvd_body[0] = 3;
        lvd_body[1] = 0;
        lvd_body[2] = 0;
        lvd_body[3] = 0;
        lvd_body[4] = 0;
        byte[] DescriptorCharacterSet = this.stringToBytes("OSTA Compressed Unicode");
        for (int i3 = 0; i3 < DescriptorCharacterSet.length; ++i3) {
            lvd_body[i3 + 5] = (byte)(DescriptorCharacterSet[i3] & 0xFF);
        }
        byte[] LogicalVolumeIdentifier = this.stringToBytes1(this.imageIdentifier);
        for (int i4 = 0; i4 < LogicalVolumeIdentifier.length; ++i4) {
            lvd_body[i4 + 68] = LogicalVolumeIdentifier[i4];
        }
        lvd_body[195] = (byte)(LogicalVolumeIdentifier.length & 0xFF);
        lvd_body[196] = 0;
        lvd_body[197] = 8;
        lvd_body[198] = 0;
        lvd_body[199] = 0;
        lvd_body[200] = 0;
        byte[] DomainIdentifier = this.stringToBytes("*OSTA UDF Compliant");
        for (i2 = 0; i2 < DomainIdentifier.length; ++i2) {
            lvd_body[201 + i2] = DomainIdentifier[i2];
        }
        for (i2 = 0; i2 < 8; ++i2) {
            lvd_body[224 + i2] = this.udfVersionIdentifierSuffix[i2];
        }
        lvd_body[232] = 0;
        lvd_body[233] = 8;
        lvd_body[234] = 0;
        lvd_body[235] = 0;
        lvd_body[236] = (byte)(myUDFLayoutInformation.FSDLocation >> 0 & 0xFFL);
        lvd_body[237] = (byte)(myUDFLayoutInformation.FSDLocation >> 8 & 0xFFL);
        lvd_body[238] = (byte)(myUDFLayoutInformation.FSDLocation >> 16 & 0xFFL);
        lvd_body[239] = (byte)(myUDFLayoutInformation.FSDLocation >> 24 & 0xFFL);
        lvd_body[240] = (byte)(myUDFLayoutInformation.partitionToStoreMetadataOn >> 16 & 0xFF);
        lvd_body[241] = (byte)(myUDFLayoutInformation.partitionToStoreMetadataOn >> 24 & 0xFF);
        lvd_body[248] = 6;
        lvd_body[249] = 0;
        lvd_body[250] = 0;
        lvd_body[251] = 0;
        lvd_body[252] = 1;
        lvd_body[253] = 0;
        lvd_body[254] = 0;
        lvd_body[255] = 0;
        lvd_body[256] = 0;
        byte[] ImplementationIdentifier = this.stringToBytes(this.applicationIdentifier);
        for (i = 0; i < ImplementationIdentifier.length; ++i) {
            lvd_body[i + 257] = (byte)(ImplementationIdentifier[i] & 0xFF);
        }
        for (i = 0; i < 8; ++i) {
            lvd_body[i + 280] = this.applicationIdentifierSuffix[i];
        }
        long lvid_length = (myUDFLayoutInformation.LVIDSEndingBlock - myUDFLayoutInformation.LVIDSStartingBlock) * 2048L;
        lvd_body[416] = (byte)(lvid_length >> 0 & 0xFFL);
        lvd_body[417] = (byte)(lvid_length >> 8 & 0xFFL);
        lvd_body[418] = (byte)(lvid_length >> 16 & 0xFFL);
        lvd_body[419] = (byte)(lvid_length >> 24 & 0xFFL);
        lvd_body[420] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 0 & 0xFFL);
        lvd_body[421] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 8 & 0xFFL);
        lvd_body[422] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 16 & 0xFFL);
        lvd_body[423] = (byte)(myUDFLayoutInformation.LVIDSStartingBlock >> 24 & 0xFFL);
        lvd_body[424] = 1;
        lvd_body[425] = 6;
        lvd_body[426] = 1;
        lvd_body[427] = 0;
        lvd_body[428] = 0;
        lvd_body[429] = 0;
        int DescriptorCRC = this.checkSum(lvd_body);
        lvd[0] = 6;
        lvd[1] = 0;
        lvd[2] = 2;
        lvd[3] = 0;
        lvd[5] = 0;
        lvd[6] = 1;
        lvd[7] = 0;
        lvd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        lvd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        lvd[10] = -82;
        lvd[11] = 1;
        lvd[12] = (byte)(LVDBlock >> 0 & 0xFFL);
        lvd[13] = (byte)(LVDBlock >> 8 & 0xFFL);
        lvd[14] = (byte)(LVDBlock >> 16 & 0xFFL);
        lvd[15] = (byte)(LVDBlock >> 24 & 0xFFL);
        int checksum = lvd[0] + lvd[1] + lvd[2] + lvd[3] + lvd[5] + lvd[6] + lvd[7] + lvd[8] + lvd[9] + lvd[10] + lvd[11] + lvd[12] + lvd[13] + lvd[14] + lvd[15] & 0xFF;
        lvd[4] = (byte)(checksum & 0xFF);
        for (int i5 = 0; i5 < lvd_body.length; ++i5) {
            lvd[i5 + 16] = lvd_body[i5];
        }
        this.writeToMap(lvd);
    }

    private void writePD(UdfLayoutInformation myUDFLayoutInformation, long PDBlock) {
        int i;
        byte[] pd = new byte[2048];
        byte[] pd_body = new byte[496];
        pd_body[0] = 2;
        pd_body[1] = 0;
        pd_body[2] = 0;
        pd_body[3] = 0;
        pd_body[4] = 1;
        pd_body[5] = 0;
        pd_body[6] = 0;
        pd_body[7] = 0;
        pd_body[8] = 0;
        byte[] PartitionContentIdentifie = this.stringToBytes("+NSR02");
        for (int i2 = 0; i2 < PartitionContentIdentifie.length; ++i2) {
            pd_body[9 + i2] = (byte)(PartitionContentIdentifie[i2] & 0xFF);
        }
        pd_body[168] = 1;
        pd_body[169] = 0;
        pd_body[170] = 0;
        pd_body[171] = 0;
        pd_body[172] = (byte)(myUDFLayoutInformation.physicalPartitionStartingBlock >> 0 & 0xFFL);
        pd_body[173] = (byte)(myUDFLayoutInformation.physicalPartitionStartingBlock >> 8 & 0xFFL);
        pd_body[174] = (byte)(myUDFLayoutInformation.physicalPartitionStartingBlock >> 16 & 0xFFL);
        pd_body[175] = (byte)(myUDFLayoutInformation.physicalPartitionStartingBlock >> 24 & 0xFFL);
        long pd_part_length = myUDFLayoutInformation.physicalPartitionEndingBlock - myUDFLayoutInformation.physicalPartitionStartingBlock;
        pd_body[176] = (byte)(pd_part_length >> 0 & 0xFFL);
        pd_body[177] = (byte)(pd_part_length >> 8 & 0xFFL);
        pd_body[178] = (byte)(pd_part_length >> 16 & 0xFFL);
        pd_body[179] = (byte)(pd_part_length >> 24 & 0xFFL);
        pd_body[180] = 0;
        byte[] ImplementationIdentifier = this.stringToBytes(this.applicationIdentifier);
        byte[] ImplementationIdentifierSuffix = this.applicationIdentifierSuffix;
        for (i = 0; i < ImplementationIdentifier.length; ++i) {
            pd_body[181 + i] = (byte)(ImplementationIdentifier[i] & 0xFF);
        }
        for (i = 0; i < ImplementationIdentifierSuffix.length; ++i) {
            pd_body[204 + i] = (byte)(ImplementationIdentifierSuffix[i] & 0xFF);
        }
        int DescriptorCRC = this.checkSum(pd_body);
        pd[0] = 5;
        pd[1] = 0;
        pd[2] = 2;
        pd[3] = 0;
        pd[5] = 0;
        pd[6] = 1;
        pd[7] = 0;
        pd[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        pd[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        pd[10] = -16;
        pd[11] = 1;
        pd[12] = (byte)(PDBlock >> 0 & 0xFFL);
        pd[13] = (byte)(PDBlock >> 8 & 0xFFL);
        pd[14] = (byte)(PDBlock >> 16 & 0xFFL);
        pd[15] = (byte)(PDBlock >> 24 & 0xFFL);
        int checksum = pd[0] + pd[1] + pd[2] + pd[3] + pd[5] + pd[6] + pd[7] + pd[8] + pd[9] + pd[10] + pd[11] + pd[12] + pd[13] + pd[14] + pd[15] & 0xFF;
        pd[4] = (byte)(checksum & 0xFF);
        for (int i3 = 0; i3 < pd_body.length; ++i3) {
            pd[i3 + 16] = pd_body[i3];
        }
        this.writeToMap(pd);
    }

    private byte[] stringToBytes1(String str) {
        ArrayList<Byte> strTo8 = new ArrayList<Byte>();
        byte st8h = 8;
        strTo8.add(st8h);
        ArrayList<Byte> strTo16 = new ArrayList<Byte>();
        byte st16h = 16;
        strTo16.add(st16h);
        boolean is_utf16 = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0000' && ch < '\u0080') {
                strTo8.add((byte)(ch & 0xFF));
                strTo16.add((byte)0);
                strTo16.add((byte)(ch & 0xFF));
                continue;
            }
            strTo16.add((byte)(ch >> 8 & 0xFF));
            strTo16.add((byte)(ch & 0xFF));
            is_utf16 = true;
        }
        byte[] byter8 = new byte[strTo8.size()];
        byte[] byter16 = new byte[strTo16.size()];
        int j = 0;
        Iterator iterator = strTo8.iterator();
        while (iterator.hasNext()) {
            byte b;
            byter8[j] = b = ((Byte)iterator.next()).byteValue();
            ++j;
        }
        int k = 0;
        Iterator iterator2 = strTo16.iterator();
        while (iterator2.hasNext()) {
            byte b = (Byte)iterator2.next();
            byter16[k++] = b;
        }
        return is_utf16 ? byter16 : byter8;
    }

    private byte[] stringToBytes(String str) {
        try {
            byte[] b = str.getBytes("UTF-8");
            return b;
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtil.error("UnsupportedEncodingException");
            byte[] b2 = new byte[1];
            return b2;
        }
    }

    private byte[] millis2TimeStamp(Calendar cal) {
        byte[] mytimestamp = new byte[12];
        int YY = cal.get(1);
        int MM = cal.get(2) + 1;
        int DD = cal.get(5);
        int HH = cal.get(11);
        int mm = cal.get(12);
        int SS = cal.get(13);
        int MI = cal.get(14);
        int twelveBitSignedValue = -(cal.get(15) + cal.get(16)) / 60000;
        if (twelveBitSignedValue < 0) {
            twelveBitSignedValue *= -1;
        }
        int TypeAndTimezone = 0x1000 | twelveBitSignedValue;
        mytimestamp[0] = (byte)(TypeAndTimezone >> 0 & 0xFF);
        mytimestamp[1] = (byte)(TypeAndTimezone >> 8 & 0xFF);
        mytimestamp[2] = (byte)(YY >> 0 & 0xFF);
        mytimestamp[3] = (byte)(YY >> 8 & 0xFF);
        mytimestamp[4] = (byte)(MM & 0xFF);
        mytimestamp[5] = (byte)(DD & 0xFF);
        mytimestamp[6] = (byte)(HH & 0xFF);
        mytimestamp[7] = (byte)(mm & 0xFF);
        mytimestamp[8] = (byte)(SS & 0xFF);
        mytimestamp[9] = (byte)(MI / 100 & 0xFF);
        mytimestamp[10] = (byte)(MI % 100 & 0xFF);
        mytimestamp[11] = 0;
        return mytimestamp;
    }

    public byte[] int64ToBytes(long value) {
        byte[] src = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
        return src;
    }

    private void writeEmptyBlock(int blocks) {
        int bufferLength = blocks * 2048;
        byte[] buffer = new byte[bufferLength];
        this.writeToMap(buffer);
    }

    private void writeReserve() {
        this.writeEmptyBlock(16);
    }

    private void writeEmptyArea() {
        this.writeEmptyBlock(237);
    }

    private void writeEmptyArea2() {
        this.writeEmptyBlock(10);
    }

    private void writeEmptyArea3() {
        this.writeEmptyBlock(2);
    }

    private void writeEmptyArea4() {
        this.writeEmptyBlock(1);
    }

    private void writeAVDP(long tagLocation, long MVDSBlock, long RVDSBlock) {
        int bufferLength = 2048;
        byte[] avdp = new byte[bufferLength];
        byte[] avdp_body = new byte[496];
        long mvds_len = 32768L;
        avdp_body[0] = (byte)(mvds_len >> 0 & 0xFFL);
        avdp_body[1] = (byte)(mvds_len >> 8 & 0xFFL);
        avdp_body[2] = (byte)(mvds_len >> 16 & 0xFFL);
        avdp_body[3] = (byte)(mvds_len >> 24 & 0xFFL);
        long mvds_loc = MVDSBlock;
        avdp_body[4] = (byte)(mvds_loc >> 0 & 0xFFL);
        avdp_body[5] = (byte)(mvds_loc >> 8 & 0xFFL);
        avdp_body[6] = (byte)(mvds_loc >> 16 & 0xFFL);
        avdp_body[7] = (byte)(mvds_loc >> 24 & 0xFFL);
        long rvds_len = 32768L;
        avdp_body[8] = (byte)(rvds_len >> 0 & 0xFFL);
        avdp_body[9] = (byte)(rvds_len >> 8 & 0xFFL);
        avdp_body[10] = (byte)(rvds_len >> 16 & 0xFFL);
        avdp_body[11] = (byte)(rvds_len >> 24 & 0xFFL);
        long rvds_loc = RVDSBlock;
        avdp_body[12] = (byte)(rvds_loc >> 0 & 0xFFL);
        avdp_body[13] = (byte)(rvds_loc >> 8 & 0xFFL);
        avdp_body[14] = (byte)(rvds_loc >> 16 & 0xFFL);
        avdp_body[15] = (byte)(rvds_loc >> 24 & 0xFFL);
        int DescriptorCRC = this.checkSum(avdp_body);
        avdp[0] = 2;
        avdp[1] = 0;
        avdp[2] = 2;
        avdp[3] = 0;
        avdp[5] = 0;
        avdp[6] = 1;
        avdp[7] = 0;
        avdp[8] = (byte)(DescriptorCRC >> 0 & 0xFF);
        avdp[9] = (byte)(DescriptorCRC >> 8 & 0xFF);
        avdp[10] = -16;
        avdp[11] = 1;
        avdp[12] = (byte)(tagLocation >> 0 & 0xFFL);
        avdp[13] = (byte)(tagLocation >> 8 & 0xFFL);
        avdp[14] = (byte)(tagLocation >> 16 & 0xFFL);
        avdp[15] = (byte)(tagLocation >> 24 & 0xFFL);
        int checksum = avdp[0] + avdp[1] + avdp[2] + avdp[3] + avdp[5] + avdp[6] + avdp[7] + avdp[8] + avdp[9] + avdp[10] + avdp[11] + avdp[12] + avdp[13] + avdp[14] + avdp[15] & 0xFF;
        avdp[4] = (byte)(checksum & 0xFF);
        for (int i = 0; i < avdp_body.length; ++i) {
            avdp[i + 16] = avdp_body[i];
        }
        this.writeToMap(avdp);
    }

    private int checkSum(byte[] s) {
        int[] crc_table = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
        int crc = 0;
        for (int n = 0; n < s.length; ++n) {
            crc = crc_table[(crc >> 8 ^ s[n]) & 0xFF] ^ crc << 8;
        }
        return crc & 0xFFFF;
    }

    private void writeVRS() {
        byte[] vrsBegin = new byte[2048];
        vrsBegin[0] = 0;
        byte[] vrsBeginId = this.stringToBytes("BEA01");
        for (int i = 0; i < 5; ++i) {
            vrsBegin[i + 1] = (byte)(vrsBeginId[i] & 0xFF);
        }
        vrsBegin[6] = 1;
        byte[] vrsDescriptor = new byte[2048];
        vrsDescriptor[0] = 0;
        byte[] vrsDescriptorId = this.stringToBytes("NSR02");
        for (int i = 0; i < 5; ++i) {
            vrsDescriptor[i + 1] = (byte)(vrsDescriptorId[i] & 0xFF);
        }
        vrsDescriptor[6] = 1;
        byte[] vrsTerminating = new byte[2048];
        vrsTerminating[0] = 0;
        byte[] vrsTerminatingId = this.stringToBytes("TEA01");
        for (int i = 0; i < 5; ++i) {
            vrsTerminating[i + 1] = (byte)(vrsTerminatingId[i] & 0xFF);
        }
        vrsTerminating[6] = 1;
        byte[] vrssum = new byte[6144];
        for (int i1 = 0; i1 < 2048; ++i1) {
            vrssum[i1] = vrsBegin[i1];
        }
        for (int i2 = 2048; i2 < 4096; ++i2) {
            vrssum[i2] = vrsDescriptor[i2 - 2048];
        }
        for (int i3 = 4096; i3 < 6144; ++i3) {
            vrssum[i3] = vrsTerminating[i3 - 4096];
        }
        this.writeToMap(vrssum);
    }

    private void writeToMap(byte[] buf) {
        UDFExtendFile udfFile = new UDFExtendFile();
        udfFile.setContent(buf);
        udfFile.setExtendData(false);
        udfFile.setFileActalLen(0L);
        udfFile.setFileLen(buf.length);
        long lastposition = this.keylist.get(this.keylist.size() - 1);
        udfFile.setPosition(lastposition);
        long nowposition = lastposition + udfFile.getFileLen();
        this.keylist.add(nowposition);
        this.extendMap.put(udfFile.getPosition(), udfFile);
    }

    private void writeToMapLarge(File sourceFile) {
        UDFExtendFile udfFile = new UDFExtendFile();
        try {
            udfFile.setContent(sourceFile.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtil.error("UnsupportedEncodingException ");
        }
        udfFile.setExtendData(true);
        long fileLen = sourceFile.length();
        udfFile.setFileActalLen(fileLen);
        if (0L == fileLen % (long)this.blockSize) {
            udfFile.setFileLen(fileLen);
        } else {
            udfFile.setFileLen(fileLen + ((long)this.blockSize - fileLen % (long)this.blockSize));
        }
        long lastposition = this.keylist.get(this.keylist.size() - 1);
        udfFile.setPosition(lastposition);
        long nowposition = lastposition + udfFile.getFileLen();
        this.keylist.add(nowposition);
        this.extendMap.put(udfFile.getPosition(), udfFile);
    }
}

